TITLE   'Bar Heated by Moving Torch, Stationary PDE'     { exa194.pde }
SELECT     							
   errlim=1e-3     ngrid=4     spectral_colors
VARIABLES   temp
DEFINITIONS
   Lx=1.0      Ly=0.2     d0=0.1     vx=1e-3 		{ Velocity }
   k=82     rcp=7.87e3*449 					{ Steel }
   heat=0     tempi=300     t0=800
   fluxd_x=-k*dx(temp)     fluxd_y=-k*dy(temp)
   fluxd=vector( fluxd_x, fluxd_y)     fluxdm=magnitude( fluxd)	
   fluxd0=-1e6*[ ustep( vx*t0+d0- x)- ustep( vx*t0- x) ]
EQUATIONS
   div( fluxd)- rcp*vx*dx(temp)=heat
BOUNDARIES
region 'domain'
   start (0,0)  value(temp)=tempi  line to (Lx,0)
   natural(temp)=0 line to (Lx,Ly)
   natural(temp)=fluxd0  line to (0,Ly)
   natural(temp)=0 line to close
PLOTS
   elevation( temp) from (0,Ly) to (Lx,Ly)
   contour( temp) painted     surface( temp)     vector( fluxd) norm
END
ur( temp) painted     surface( temp)     vector( fluxd) norm
END

